###### Valor do M3  ###########

# Atencao: Este script foi salvo criado com codificacao UTF-8.

# Essa função tem como argumentos: produto e grupo. 
# produto = (tora, acabado)
# grupo = (geral, grupo1, grupo2, grupo3)


# Carrega pacotes a serem utilizados
    library(data.table)
    library(dplyr)
    library(tidyr)
    library(ggplot2)
    library(ggrepel) # para evitar a sobreposicao de labels. usar geom_label_repel
    #library(scater) # para a funcao multiplot

    #  Lê sisdof_tora
    sisdof_tora <- fread("SisDOF-toras_2012_2017.csv",
                         colClasses = c("character", "character", "character",
                                        "character", "character", "character",
                                        "character", "character", "character",
                                        "character", "character", "character",
                                        "character", "character", "character",
                                        "character", "numeric", "numeric"))
    
    # Deleta coluna V1 criada pelo comando fread.
    sisdof_tora$V1 <- NULL
    
    # Lê sisdof_produto
    sisdof_produto <- fread("SisDOF_Destino_2012_2017.csv",
                            colClasses = c("character", "character", "character",
                                           "character", "character", "character",
                                           "character", "character", "character",
                                           "character", "character", "character",
                                           "character", "character", "character",
                                           "character", "numeric", "numeric"))
    
    # Deleta coluna V1 criada pelo comando fread.
    sisdof_produto$V1 <- NULL

preco_m3 <- function (produto, grupo) {
    # produto = (tora, acabado)
    
    # grupo = (geral, grupo1, grupo2, grupo3)
    # geral = Todas as espécies
    # grupo1 = especies de grande movimentacao
    # grupo2 = ameacadas (Portaria 443)
    # grupo3 = cites
    
    # Função para passar apenas a primeira letra de uma palavra para maiúscula
    capFirst <- function(s) {
        paste(toupper(substring(s, 1, 1)), substring(s, 2), sep = "")
    }
    
    # Títulos do gráfico
    titulo <- capFirst(grupo)
    
    if (produto == "tora") {
        
        # Muda diretório de trabalho para o de Toras. Cria o diretorio se ja nao existir.
        
        ifelse(!dir.exists(file.path("Figuras", 
                                     "1.1.Toras", 
                                     "1.1.6.Preco.M3")),
               dir.create(file.path("Figuras",
                                    "1.1.Toras",
                                    "1.1.6.Preco.M3"),
                          recursive = TRUE,
                          showWarnings = FALSE),
               FALSE)
        
        setwd(file.path("Figuras", 
                        "1.1.Toras", 
                        "1.1.6.Preco.M3"))
        
        # sisdof =  sisdof_tora
        sisdof <- sisdof_tora
        
        # Nome no eixo y dos gráficos a serem gerados
        nome <- "Valor Médio das Madeiras Produzidas"
        
        } else if (produto == "acabado") {
            
            # Muda diretório de trabalho para o de Toras. Cria o diretorio se ja nao existir.
            
            ifelse(!dir.exists(file.path("Figuras", 
                                         "1.2.Produto.Acabado", 
                                         "1.2.6.Preco.M3")),
                   dir.create(file.path("Figuras", 
                                        "1.2.Produto.Acabado", 
                                        "1.2.6.Preco.M3"),
                              recursive = TRUE,
                              showWarnings = FALSE),
                   FALSE)
            
            setwd(file.path("Figuras", 
                            "1.2.Produto.Acabado", 
                            "1.2.6.Preco.M3"))
            
            # sisdof = sisdof_produto
            sisdof <- sisdof_produto
        
            # Nome no eixo y dos gráficos a serem gerados
            nome <- "Valor Médio dos Produtos Madeireiros Consumidos"
            
            } 
    
    if (grupo == "grupo1") {
            
            lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.1"]$Especie)   # lista os nomes das espécies contidas no grupo 1
           
            } else if (grupo == "grupo2") {
                
                lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.2"]$Especie)   # lista os nomes das espécies contidas no grupo 2
                
                } else if (grupo == "grupo3") {
                    
                    lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.3"]$Especie)   # lista os nomes das espécies contidas no grupo 3
                    
                }
    
    y <- sisdof
    
    # Elimina o mês, mantendo apenas o ano
    y$Emissao <- as.numeric(sub("^[0-9]+-", "", y$Emissao))
    
    y <- y[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                  by = .(Especie, 
                         Emissao,
                         Portaria.443,
                         Cites)]
    
    # Renomeia as colunas V1 e V2  
    y <- dplyr::rename(y,
                              "Volume.Total" = "V1",
                              "Preco.Total" = "V2")
    
    nomes.443 <- unique(y$Especie[!is.na(y$Portaria.443)])
    
    nomes.cites <- unique(y$Especie[!is.na(y$Cites)])
    
    ## Cria o subset geral
    geral <- y
    
    # Cria a coluna Categoria para agrupar os graficos
    geral$Categoria <- "Todas as espécies"
    
    # Agrega
    geral <- geral[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                       by = .(Emissao,
                              Categoria)]
    
    # Renomeia as colunas V1 e V2  
    geral <- dplyr::rename(geral,
                       "Volume.Total" = "V1",
                       "Preco.Total" = "V2")
    
    ## Cria o subset Portaria 443
    agregado443 <- y[!is.na(y$Portaria.443)]
    
    # Cria a coluna Categoria
    agregado443$Categoria <- "Espécies ameaçadas de extinção"
    
    # Agrega
    agregado443 <- agregado443[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                               by = .(Emissao,
                                      Categoria)]
    
    # Renomeia as colunas V1 e V2  
    agregado443 <- dplyr::rename(agregado443,
                                 "Volume.Total" = "V1",
                                 "Preco.Total" = "V2")
    
    ## Cria o subset Cites
    agregadocites <- y[!is.na(y$Cites)]
    
    # Cria a coluna Categoria
    agregadocites$Categoria <- "Espécies CITES"
    
    # Agrega
    agregadocites <- agregadocites[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                               by = .(Emissao,
                                      Categoria)]
    
    # Renomeia as colunas V1 e V2  
    agregadocites <- dplyr::rename(agregadocites,
                                 "Volume.Total" = "V1",
                                 "Preco.Total" = "V2")
    
    ## Faz o gráfico das especies
    
    #if (grupo == "geral") {
        
    #    lista_especies <- "Grupos de Espécies"
    
        especie <- rbind(geral, agregado443, agregadocites)
        
        especie$Categoria <- factor(especie$Categoria, 
                                    levels = c("Todas as espécies",
                                               "Espécies ameaçadas de extinção",
                                               "Espécies CITES"))
        
        # Ordena de forma crescente em relação a data
        especie <- especie[order(especie$Emissao),]
        
        # Cria a coluna Preco.M3
        especie$Preco.M3 <- especie$Preco.Total/especie$Volume.Total
        
        # Cria tabela com informações gerais
        dados <- data.table("Especie" = as.character(unique(especie$Categoria)),
                            "Preco.2012" = round(especie$Preco.M3[especie$Emissao == "2012" & 
                                                                        especie$Categoria == as.character(unique(especie$Categoria))],2),
                            "Preco.2013" = round(especie$Preco.M3[especie$Emissao == "2013" & 
                                                                        especie$Categoria == as.character(unique(especie$Categoria))],2),
                            "Preco.2014" = round(especie$Preco.M3[especie$Emissao == "2014" & 
                                                                        especie$Categoria == as.character(unique(especie$Categoria))],2),
                            "Preco.2015" = round(especie$Preco.M3[especie$Emissao == "2015" & 
                                                                        especie$Categoria == as.character(unique(especie$Categoria))],2),
                            "Preco.2016" = round(especie$Preco.M3[especie$Emissao == "2016" & 
                                                                        especie$Categoria == as.character(unique(especie$Categoria))],2),
                            "Preco.2017" = round(especie$Preco.M3[especie$Emissao == "2017" & 
                                                                        especie$Categoria == as.character(unique(especie$Categoria))],2))
        
        if (grupo == "geral") {
            
            lista_especies <- "Grupos de Espécies"
            
        gplot <- ggplot(especie, aes(x = Emissao, 
                                     y = Preco.M3,
                                     colour = factor(Categoria)))+
            facet_wrap(~ Categoria, nrow = 2, scales = "free_y")+
            geom_vline(data = data.frame(xint=2014,
                                         Categoria = "Espécies ameaçadas de extinção"),
                       aes(xintercept=xint),
                       linetype="F1")+
            geom_point() +                                                  # adiciona os pontos no gráfico
            #geom_line() +                                                  # adiciona uma linha reta ligando cada um dos pontos do gráfico
            geom_smooth(method = "loess")+                                  # adiciona uma reta curva conforme os pontos do gráficos.
            #geom_label(data = especie,                                      # adiciona uma caixa de texto com os valores de y do gráfico
            #           aes(label = format(round(Preco.M3, 2),
            #                              big.mark = ".", 
            #                              decimal.mark = ",")),             # indica que o texto da caixa de texto serao os valores do Volume.Total/1000, mostrando apenas duas casas decimais. O separador de milhar e "." e o separador de decimal e ",".)),    # indica que o texto da caixa de texto serão os valores do Volume.Total/1000, mostrando apenas duas casas decimais
            #           vjust = "inward",                                    # alinhamento vertical da caixa de texto
            #           hjust = "inward",                                    # alinhamento horizontal da caixa de texto
            #           size = 4,                                            # tamanho do texto da caixa de texto 
            #           label.size = 0.1)+                                   # tamanho da borda da caixa de texto 
            geom_label_repel(
                data = especie,
                aes(label = format(round(Preco.M3, 2),
                                   big.mark = ".",
                                   decimal.mark = ",")),
                segment.size  = 0.2,
                segment.color = "grey50",
                box.padding = unit(0.35, "lines"),
                size = 4) +
            theme(strip.text.x = element_text(size = 14),                   # tamanho do titulo de cada um dos graficos do facet_wrap
                  axis.title.x = element_text(size = 14),                   # tamanho dos titulo do eixo x ("Ano")
                  axis.text.x = element_text(size = 12),                    # tamanho dos valores do eixo x (2012, 2013...)
                  axis.title.y = element_text(size = 14),                   # tamanho do titulo do eixo y
                  axis.text.y = element_blank(),                            # elimina o texto dos valores do eixo y (volume movimentado). Esses valores estarao na caixa de texto
                  axis.ticks.y = element_blank(),                           # elimina os marcos (ticks) do eixo y
                  legend.position = "none",                                 # elimina a legenda
                  plot.title = element_text(lineheight=.8,                  # formata o titulo do grafico
                                            face="bold",
                                            hjust=0.5,
                                            size = 18),
                  panel.grid.minor = element_blank())+                      # elimina os grids menores
            ylab("Valor das movimentações (R$/m^3)") +
            xlab("Ano") +
            ggtitle(paste0(nome,
                           "\n",
                           lista_especies,
                           " - ",
                           "2012 a 2017"))+
            scale_color_brewer(palette = "Dark2")+                           # usa a paleta de cores "Dark2" do pacote RColorBrewer
            scale_fill_manual("white")
        
            
        
        # Abre para gravacao em PDF
          pdf(paste0("#", 
                     titulo, 
                     "_Preco_M3.pdf"), 
              width = 8, 
              height = 6.5)
        
        print(gplot)
        
        # Fecha o PDF
        dev.off() 
        
        }
        
        if (grupo == "grupo1" | grupo == "grupo2" | grupo == "grupo3") {
        
        for (i in 1:length(lista_especies)) {
            especie <- y[y$Especie == lista_especies[i]]
            
            # Renomeia a coluna Especie para Categoria
            especie <- dplyr::rename(especie,
                                     "Categoria" = "Especie")
            
            # Deleta as colunas Portaria.443 e Cites de especie
            especie <- especie[, -(Portaria.443:Cites)]
            
            # Fusiona especie e geral
            especie <- rbind(especie, geral)
            
            if (grupo == "grupo1") {
                
                especie$Categoria <- factor(especie$Categoria, 
                                            levels = c(lista_especies[i],
                                                       "Todas as espécies"))
               
                 if (lista_especies[i] %in% nomes.443) {
                     
                     especie <- rbind(especie, agregado443)
                     
                     especie$Categoria <- factor(especie$Categoria, 
                                            levels = c(lista_especies[i],
                                                       "Todas as espécies",
                                                       "Espécies ameaçadas de extinção"))
                     
                     } 
                
                if (lista_especies[i] %in% nomes.cites) {
                    
                    especie <- rbind(especie, agregadocites)
                    
                    especie$Categoria <- factor(especie$Categoria, 
                                                levels = c(lista_especies[i],
                                                           "Todas as espécies",
                                                           "Espécies CITES"))
                    
                    if (lista_especies[i] %in% nomes.443) {
                        
                        especie$Categoria <- factor(especie$Categoria, 
                                                    levels = c(lista_especies[i],
                                                               "Todas as espécies",
                                                               "Espécies ameaçadas de extinção",
                                                               "Espécies CITES"))
                        
                    } 
                    
                    
                }
                
                } else if (grupo == "grupo2") {
                    
                    especie <- rbind(especie, agregado443)
                    
                    especie$Categoria <- factor(especie$Categoria, 
                                            levels = c(lista_especies[i],
                                                       "Todas as espécies",
                                                       "Espécies ameaçadas de extinção"))
                    
                    if (lista_especies[i] %in% nomes.cites) {
                        
                        especie <- rbind(especie, agregadocites)
                        
                        especie$Categoria <- factor(especie$Categoria, 
                                                levels = c(lista_especies[i],
                                                           "Todas as espécies",
                                                           "Espécies ameaçadas de extinção",
                                                           "Espécies CITES"))
                }
                
                } else if (grupo == "grupo3") {
                    
                    especie <- rbind(especie, agregadocites)
                    
                    especie$Categoria <- factor(especie$Categoria, 
                                            levels = c(lista_especies[i],
                                                       "Todas as espécies",
                                                       "Espécies CITES"))
                    
                    if (lista_especies[i] %in% nomes.443) {
                        
                        especie <- rbind(especie, agregado443)
                        
                        especie$Categoria <- factor(especie$Categoria, 
                                                levels = c(lista_especies[i],
                                                           "Todas as espécies",
                                                           "Espécies CITES",
                                                           "Espécies ameaçadas de extinção"))
                        
                    }
                    
                    }
           
                
            # Ordena de forma crescente em relação a data
            especie <- especie[order(especie$Emissao),]
            
            # Cria a coluna Volume.Relativo, em funcao do volume de 2012
            especie$Preco.M3 <- especie$Preco.Total/especie$Volume.Total
            
          
            # Gera o grafico
            gplot <- ggplot(especie, aes(x = Emissao, 
                                         y = Preco.M3,
                                         colour = factor(Categoria))) +
                #scale_x_datetime(date_labels = "%Y") + 
                facet_wrap(~ Categoria, nrow = 2, scales = "free_y")+
                geom_point() +                                                  # adiciona os pontos no gráfico
                #geom_line() +                                                  # adiciona uma linha reta ligando cada um dos pontos do gráfico
                geom_smooth(method = "loess")+                                  # adiciona uma reta curva conforme os pontos do gráficos.
                #geom_label(data = especie,                                      # adiciona uma caixa de texto com os valores de y do gráfico
                #           aes(label = format(round(Preco.M3, 2),
                #                              big.mark = ".", 
                #                              decimal.mark = ",")),             # indica que o texto da caixa de texto serao os valores do Volume.Total/1000, mostrando apenas duas casas decimais. O separador de milhar e "." e o separador de decimal e ",".)),    # indica que o texto da caixa de texto serão os valores do Volume.Total/1000, mostrando apenas duas casas decimais
                #           vjust = "inward",                                    # alinhamento vertical da caixa de texto
                #           hjust = "inward",                                    # alinhamento horizontal da caixa de texto
                #           size = 4,                                            # tamanho do texto da caixa de texto 
                #           label.size = 0.1)+                                   # tamanho da borda da caixa de texto 
                geom_label_repel(data = especie,                                 # usando geom_label_repel ao inves de geom_label evita sobreposicao das caixas de texto com os valores dos precos.
                                 aes(label = format(round(Preco.M3, 2),
                                       big.mark = ".",
                                       decimal.mark = ",")),
                    segment.size  = 0.2,
                    segment.color = "grey50",
                    box.padding = unit(0.35, "lines"),
                    size = 4) +
                theme(strip.text.x = element_text(size = 14),                   # tamanho do titulo de cada um dos graficos do facet_wrap
                      axis.title.x = element_text(size = 14),                   # tamanho dos titulo do eixo x ("Ano")
                      axis.text.x = element_text(size = 12),                    # tamanho dos valores do eixo x (2012, 2013...)
                      axis.title.y = element_text(size = 14),                   # tamanho do titulo do eixo y
                      axis.text.y = element_blank(),                            # elimina o texto dos valores do eixo y (volume movimentado). Esses valores estarao na caixa de texto
                      axis.ticks.y = element_blank(),                           # elimina os marcos (ticks) do eixo y
                      legend.position = "none",                                 # elimina a legenda
                      plot.title = element_text(lineheight=.8,                  # formata o titulo do grafico
                                                face="bold",
                                                hjust=0.5,
                                                size = 18),
                      panel.grid.minor = element_blank())+                      # elimina os grids menores
                ylab("Valor das movimentações (R$/m^3)") +
                xlab("Ano") +
                ggtitle(paste0(nome,
                               "\n",
                               lista_especies[i],
                               " - ",
                               "2012 a 2017"))+
                scale_color_brewer(palette = "Dark2")+                           # usa a paleta de cores "Dark2" do pacote RColorBrewer
                scale_fill_manual("white")
                
            
            # Abre para gravacao em PDF
            pdf(paste0(titulo, 
                       "_", 
                       lista_especies[i], 
                       "_Preco_M3.pdf"), 
                width = 8, 
                height = 6.5)
            
            print(gplot)
            
            # Fecha o PDF
            dev.off()
            
            # Faz tabela com dados
            dados.esp <- data.table()
            for (j in 2012:2017) {
                
                if (length(especie$Preco.M3[especie$Emissao == j &
                                                especie$Categoria == lista_especies[i]]) != 0) {
                    
                    dados.esp1 <- data.table("Especie" = lista_especies[i],
                                             "Ano" = round(especie$Preco.M3[especie$Emissao == j &
                                                                                    especie$Categoria == lista_especies[i]], 2))
                    
                    colnames(dados.esp1) <- c("Especie", paste0("Preco.", as.character(j)))
                    
                } else {
                    
                    dados.esp1 <- data.table("Especie" = lista_especies[i],
                                             "Ano" = NA)
                    colnames(dados.esp1) <- c("Especie", paste0("Preco.", as.character(j)))
                    
                }
                
                if (j == 2012) {
                    
                    dados.esp <- dados.esp1
                    
                } else {
                    
                    dados.esp <- cbind(dados.esp, dados.esp1[,2])
                }
                
            } 
            
            dados <- rbind(dados, dados.esp)
            
            
        }
            
        }
        
        
        # Faz a variaao percentual em relacao ao ano de 2012
        
        if (grupo == "grupo2") {
            
            # Faz a variaao percentual em relacao ao ano de 2012
            dados$Var.2013 <- round((dados$Preco.2013-dados$Preco.2012)/dados$Preco.2012*100, 2)
            dados$Var.2014 <- round((dados$Preco.2014-dados$Preco.2012)/dados$Preco.2012*100, 2)
            dados$Var.2015 <- round((dados$Preco.2015-dados$Preco.2012)/dados$Preco.2012*100, 2)
            dados$Var.2016 <- round((dados$Preco.2016-dados$Preco.2012)/dados$Preco.2012*100, 2)
            dados$Var.2017 <- round((dados$Preco.2017-dados$Preco.2012)/dados$Preco.2012*100, 2)
            dados$Var.2015.14 <- round((dados$Preco.2015-dados$Preco.2014)/dados$Preco.2014*100, 2)
            
        } else {
            
            # Faz a variaao percentual em relacao ao ano de 2012
            dados$Var.2013 <- round((dados$Preco.2013-dados$Preco.2012)/dados$Preco.2012*100, 2)
            dados$Var.2014 <- round((dados$Preco.2014-dados$Preco.2012)/dados$Preco.2012*100, 2)
            dados$Var.2015 <- round((dados$Preco.2015-dados$Preco.2012)/dados$Preco.2012*100, 2)
            dados$Var.2016 <- round((dados$Preco.2016-dados$Preco.2012)/dados$Preco.2012*100, 2)
            dados$Var.2017 <- round((dados$Preco.2017-dados$Preco.2012)/dados$Preco.2012*100, 2)
            
        }
        
        
        # Grava a planilha com os dados
        write.csv(dados, paste0("#", titulo, "_Preco.M3.csv"))
        
        # Sobe para o diretorio raiz do script    
        setwd("..")
        setwd("..")
        setwd("..")
        
}

preco_m3("tora", "geral")
preco_m3("tora", "grupo1")
preco_m3("tora", "grupo2")
preco_m3("tora", "grupo3")

preco_m3("acabado", "geral")
preco_m3("acabado", "grupo1")
preco_m3("acabado", "grupo2")
preco_m3("acabado", "grupo3")

    
    
    

   
    
    